
; PicBasic Pro Compiler 2.46, (c) 1998, 2005 microEngineering Labs, Inc. All Rights Reserved.  
_USED			EQU	1

	INCLUDE	"C:\PBP\16F628A.INC"


; Define statements.
#define		OSC		 4              

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
T1              		EQU	RAM_START + 012h
FLAGS           		EQU	RAM_START + 014h
GOP             		EQU	RAM_START + 015h
RM1             		EQU	RAM_START + 016h
RM2             		EQU	RAM_START + 017h
RR1             		EQU	RAM_START + 018h
RR2             		EQU	RAM_START + 019h
_Counter         		EQU	RAM_START + 01Ah
_Colm            		EQU	RAM_START + 01Ch
_Column_Scan     		EQU	RAM_START + 01Dh
_Digit_Loc       		EQU	RAM_START + 01Eh
_Digit_Pos       		EQU	RAM_START + 01Fh
_Hrs_Digit1      		EQU	RAM_START + 020h
_Hrs_Digit2      		EQU	RAM_START + 021h
_Mins_Digit1     		EQU	RAM_START + 022h
_Mins_Digit2     		EQU	RAM_START + 023h
_Row_Data        		EQU	RAM_START + 024h
_Secs_Digit1     		EQU	RAM_START + 025h
_Secs_Digit2     		EQU	RAM_START + 026h
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTA
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISA
#define _Clock_Cols      	_PORTB_6
#define _Reset_Cols      	_PORTB_5
#define _ROW1            	_PORTA_2
#define _ROW2            	_PORTA_3
#define _ROW3            	_PORTB_4
#define _ROW4            	_PORTB_3
#define _ROW5            	_PORTB_0
#define _ROW6            	_PORTB_2
#define _ROW7            	_PORTB_1
#define _Prog_Button     	_PORTA_4
#define _TX_To_PC        	_PORTB_7
#define _INTCON_5        	 INTCON, 005h
#define _INTCON_2        	 INTCON, 002h
#define _PORTB_6         	 PORTB, 006h
#define _PORTB_5         	 PORTB, 005h
#define _PORTA_2         	 PORTA, 002h
#define _PORTA_3         	 PORTA, 003h
#define _PORTB_4         	 PORTB, 004h
#define _PORTB_3         	 PORTB, 003h
#define _PORTB_0         	 PORTB, 000h
#define _PORTB_2         	 PORTB, 002h
#define _PORTB_1         	 PORTB, 001h
#define _PORTA_4         	 PORTA, 004h
#define _PORTB_7         	 PORTB, 007h

; Constants.
_T2400           		EQU	00000h
_T1200           		EQU	00001h
_T9600           		EQU	00002h
_T300            		EQU	00003h
_N2400           		EQU	00004h
_N1200           		EQU	00005h
_N9600           		EQU	00006h
_N300            		EQU	00007h
_OT2400          		EQU	00008h
_OT1200          		EQU	00009h
_OT9600          		EQU	0000Ah
_OT300           		EQU	0000Bh
_ON2400          		EQU	0000Ch
_ON1200          		EQU	0000Dh
_ON9600          		EQU	0000Eh
_ON300           		EQU	0000Fh
_MSBPRE          		EQU	00000h
_LSBPRE          		EQU	00001h
_MSBPOST         		EQU	00002h
_LSBPOST         		EQU	00003h
_LSBFIRST        		EQU	00000h
_MSBFIRST        		EQU	00001h
_CLS             		EQU	00000h
_HOME            		EQU	00001h
_BELL            		EQU	00007h
_BKSP            		EQU	00008h
_TAB             		EQU	00009h
_CR              		EQU	0000Dh
_UnitOn          		EQU	00012h
_UnitOff         		EQU	0001Ah
_UnitsOff        		EQU	0001Ch
_LightsOn        		EQU	00014h
_LightsOff       		EQU	00010h
_Dim             		EQU	0001Eh
_Bright          		EQU	00016h

; EEPROM data.
	ORG EEPROM_START

	ORG EEPROM_START + 00000h
	DE	03Eh
	DE	041h
	DE	041h
	DE	041h
	DE	03Eh
	ORG EEPROM_START + 00005h
	DE	040h
	DE	07Fh
	DE	042h
	DE	000h
	DE	000h
	ORG EEPROM_START + 0000Ah
	DE	046h
	DE	049h
	DE	051h
	DE	061h
	DE	042h
	ORG EEPROM_START + 0000Fh
	DE	036h
	DE	049h
	DE	049h
	DE	041h
	DE	022h
	ORG EEPROM_START + 00014h
	DE	010h
	DE	07Fh
	DE	012h
	DE	014h
	DE	018h
	ORG EEPROM_START + 00019h
	DE	031h
	DE	049h
	DE	049h
	DE	049h
	DE	027h
	ORG EEPROM_START + 0001Eh
	DE	032h
	DE	049h
	DE	049h
	DE	049h
	DE	03Eh
	ORG EEPROM_START + 00023h
	DE	003h
	DE	005h
	DE	009h
	DE	071h
	DE	001h
	ORG EEPROM_START + 00028h
	DE	036h
	DE	049h
	DE	049h
	DE	049h
	DE	036h
	ORG EEPROM_START + 0002Dh
	DE	03Eh
	DE	049h
	DE	049h
	DE	049h
	DE	026h
	ORG EEPROM_START + 00032h
	DE	000h
	DE	000h
	DE	000h
	DE	000h
	DE	000h
	ORG EEPROM_START + 00037h
	DE	008h
	DE	008h
	DE	008h
	DE	008h
	DE	008h

	INCLUDE	"245LED~1.MAC"
	INCLUDE	"C:\PBP\PBPPIC14.LIB"

	MOVE?CB	007h, CMCON
	MOVE?CB	087h, OPTION_REG
	MOVE?CB	010h, TRISA
	MOVE?CB	000h, TRISB
	MOVE?CT	001h, _INTCON_5
	MOVE?CT	000h, _INTCON_2
	ONINT?LL	_Clock, L00001
	ICALL?L	L00001
	MOVE?CW	07A12h, _Counter
	ICALL?L	L00001
	MOVE?CB	000h, TMR0
	ICALL?L	L00001
	MOVE?CB	000h, _Column_Scan
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	MOVE?CB	000h, _Secs_Digit1
	ICALL?L	L00001
	MOVE?CB	000h, _Secs_Digit2
	ICALL?L	L00001
	MOVE?CB	000h, _Mins_Digit1
	ICALL?L	L00001
	MOVE?CB	000h, _Mins_Digit2
	ICALL?L	L00001
	MOVE?CB	002h, _Hrs_Digit1
	ICALL?L	L00001
	MOVE?CB	001h, _Hrs_Digit2
	ICALL?L	L00001
	MOVE?CB	000h, _Colm
	ICALL?L	L00001
	MOVE?CT	001h, _Reset_Cols
	ICALL?L	L00001
	MOVE?CT	000h, _Reset_Cols

	LABEL?L	_LED_Display	

	ASM?
 incf _Column_Scan, 1                            

	ENDASM?


	ASM?
 incf _Digit_Pos, 1                              

	ENDASM?

	ICALL?L	L00001
	MOVE?CB	000h, _Row_Data
	ICALL?L	L00001
	CMPNE?BCL	_Column_Scan, 025h, L00003
	MOVE?CB	001h, _Column_Scan
	LABEL?L	L00003	
	ICALL?L	L00001
	ICALL?L	L00001
	CMPNE?BCL	_Column_Scan, 001h, L00007
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	MUL?BCB	_Secs_Digit1, 005h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00007	
	CMPNE?BCL	_Column_Scan, 006h, L00008
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	MOVE?CB	032h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00008	
	CMPNE?BCL	_Column_Scan, 007h, L00009
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	MUL?BCB	_Secs_Digit2, 005h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00009	
	CMPEQ?BCL	_Column_Scan, 00Dh, L00010
	CMPNE?BCL	_Column_Scan, 00Ch, L00011

	LABEL?L	L00010	
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	CMPNE?BCL	_Colm, 002h, L00012
	ICALL?L	L00001
	MOVE?CB	037h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00013
	LABEL?L	L00012	
	ICALL?L	L00001
	MOVE?CB	032h, _Digit_Loc
	ICALL?L	L00001
	LABEL?L	L00013	
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00011	
	CMPNE?BCL	_Column_Scan, 00Eh, L00014
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	MUL?BCB	_Mins_Digit1, 005h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00014	
	CMPNE?BCL	_Column_Scan, 013h, L00015
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	MOVE?CB	032h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00015	
	CMPNE?BCL	_Column_Scan, 014h, L00016
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	MUL?BCB	_Mins_Digit2, 005h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00016	
	CMPEQ?BCL	_Column_Scan, 01Ah, L00017
	CMPNE?BCL	_Column_Scan, 019h, L00018

	LABEL?L	L00017	
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	CMPNE?BCL	_Colm, 002h, L00019
	ICALL?L	L00001
	MOVE?CB	037h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00020
	LABEL?L	L00019	
	ICALL?L	L00001
	MOVE?CB	032h, _Digit_Loc
	ICALL?L	L00001
	LABEL?L	L00020	
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00018	
	CMPNE?BCL	_Column_Scan, 01Bh, L00021
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	MUL?BCB	_Hrs_Digit1, 005h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00021	
	CMPNE?BCL	_Column_Scan, 020h, L00022
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	MOVE?CB	032h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00006
	LABEL?L	L00022	
	CMPNE?BCL	_Column_Scan, 021h, L00023
	ICALL?L	L00001
	MOVE?CB	000h, _Digit_Pos
	ICALL?L	L00001
	CMPNE?BCL	_Hrs_Digit2, 000h, L00024
	ICALL?L	L00001
	MOVE?CB	032h, _Digit_Loc
	ICALL?L	L00001
	GOTO?L	L00025
	LABEL?L	L00024	
	ICALL?L	L00001
	MOVE?CB	005h, _Digit_Loc
	ICALL?L	L00001
	LABEL?L	L00025	
	ICALL?L	L00001
	LABEL?L	L00023	
	LABEL?L	L00006	
	ICALL?L	L00001
	ADD?BBW	_Digit_Loc, _Digit_Pos, T1
	READ?WB	T1, _Row_Data
	ICALL?L	L00001
	MOVE?CT	000h, _ROW1
	ICALL?L	L00001
	MOVE?CT	000h, _ROW2
	ICALL?L	L00001
	MOVE?CT	000h, _ROW3
	ICALL?L	L00001
	MOVE?CT	000h, _ROW4
	ICALL?L	L00001
	MOVE?CT	000h, _ROW5
	ICALL?L	L00001
	MOVE?CT	000h, _ROW6
	ICALL?L	L00001
	MOVE?CT	000h, _ROW7
	ICALL?L	L00001
	CMPNE?TCL	_Prog_Button, 000h, L00026
	GOTO?L	_Set_Time
	LABEL?L	L00026	
	ICALL?L	L00001
	MOVE?CT	001h, _Clock_Cols
	ICALL?L	L00001
	MOVE?CT	000h, _Clock_Cols
	ICALL?L	L00001
	AND?BCW	_Row_Data, 001h, T1
	CMPF?WL	T1, L00028
	MOVE?CT	001h, _ROW1
	LABEL?L	L00028	
	ICALL?L	L00001
	AND?BCW	_Row_Data, 002h, T1
	CMPF?WL	T1, L00030
	MOVE?CT	001h, _ROW2
	LABEL?L	L00030	
	ICALL?L	L00001
	AND?BCW	_Row_Data, 004h, T1
	CMPF?WL	T1, L00032
	MOVE?CT	001h, _ROW3
	LABEL?L	L00032	
	ICALL?L	L00001
	AND?BCW	_Row_Data, 008h, T1
	CMPF?WL	T1, L00034
	MOVE?CT	001h, _ROW4
	LABEL?L	L00034	
	ICALL?L	L00001
	AND?BCW	_Row_Data, 010h, T1
	CMPF?WL	T1, L00036
	MOVE?CT	001h, _ROW5
	LABEL?L	L00036	
	ICALL?L	L00001
	AND?BCW	_Row_Data, 020h, T1
	CMPF?WL	T1, L00038
	MOVE?CT	001h, _ROW6
	LABEL?L	L00038	
	ICALL?L	L00001
	AND?BCW	_Row_Data, 040h, T1
	CMPF?WL	T1, L00040
	MOVE?CT	001h, _ROW7
	LABEL?L	L00040	
	ICALL?L	L00001
	GOTO?L	_LED_Display
	DISABLE?	

	LABEL?L	_Clock	
	MOVE?CT	000h, _INTCON_2
	SUB?WCW	_Counter, 01000h, _Counter
	CMPGE?WCL	_Counter, 01000h, L00042
	CMPNE?BCL	_Colm, 002h, L00044

	ASM?
 incf _Secs_Digit1, 1                      

	ENDASM?

	CMPNE?BCL	_Secs_Digit1, 00Ah, L00046

	ASM?
 incf _Secs_Digit2, 1                   

	ENDASM?

	MOVE?CB	000h, _Secs_Digit1
	CMPNE?BCL	_Secs_Digit1, 000h, L00048
	CMPNE?BCL	_Secs_Digit2, 006h, L00050

	ASM?
 incf _Mins_Digit1, 1             

	ENDASM?

	MOVE?CB	000h, _Secs_Digit2
	CMPNE?BCL	_Mins_Digit1, 00Ah, L00052

	ASM?
 incf _Mins_Digit2, 1          

	ENDASM?

	MOVE?CB	000h, _Mins_Digit1
	CMPNE?BCL	_Mins_Digit1, 000h, L00054
	CMPNE?BCL	_Mins_Digit2, 006h, L00056

	ASM?
 incf _Hrs_Digit1, 1     

	ENDASM?

	MOVE?CB	000h, _Mins_Digit2
	CMPNE?BCL	_Hrs_Digit1, 00Ah, L00058
	MOVE?CB	000h, _Hrs_Digit1
	MOVE?CB	001h, _Hrs_Digit2
	LABEL?L	L00058	
	CMPNE?BCL	_Hrs_Digit1, 003h, L00060
	CMPNE?BCL	_Hrs_Digit2, 001h, L00062
	MOVE?CB	001h, _Hrs_Digit1
	MOVE?CB	000h, _Hrs_Digit2
	LABEL?L	L00062	
	LABEL?L	L00060	
	LABEL?L	L00056	
	LABEL?L	L00054	
	LABEL?L	L00052	
	LABEL?L	L00050	
	LABEL?L	L00048	
	LABEL?L	L00046	
	MOVE?CB	000h, _Colm
	LABEL?L	L00044	
	ADD?WCW	_Counter, 07A12h, _Counter

	ASM?
 incf _Colm, 1                                

	ENDASM?

	LABEL?L	L00042	
	RESUME?	

	LABEL?L	_Set_Time	
	LOW?T	_Prog_Button
	SERPIN?T	_TX_To_PC
	SERMODE?C	_N2400

	LABEL?L	L00002	
	SERINQ?CL	040h, L00002
	SERIN?B	_Hrs_Digit2
	SERIN?B	_Hrs_Digit1
	SERIN?B	_Mins_Digit2
	SERIN?B	_Mins_Digit1
	SERIN?B	_Secs_Digit2
	SERIN?B	_Secs_Digit1
	INPUT?T	_Prog_Button
	MOVE?CT	001h, _Reset_Cols
	MOVE?CT	000h, _Reset_Cols
	MOVE?CB	000h, _Column_Scan
	GOTO?L	_LED_Display
	END?	

	END
